/*
 * ioscm.h --- Header File for I/O Service Control Manager.
 *
 * This file is used for WindowsNT/2000/XP.
 *
 * Copyright (C) 2003-2007 by mag44(JE1TSN/M.Watanabe), all rights reserved.
 *
 */

#ifndef __IOSCM_H__
#define __IOSCM_H__

/* wOStype : Windows OS Descriptor */
#define OS_UNKNOWN  0  /* Unknown Windows  */
#define OS_WIN95    1  /* Windows 95/98/Me */
#define OS_WINNT    2  /* Windows NT/2000/XP */

/* wIOSCMflag : Result Status of IOSCM_Start() */
#define IOSCM_NOERR   (0x00)  /* IOSCM : No Error Detected */
#define IOSCM_ERROR   (0x01)  /* IOSCM : Error Detected*/
#define IOSCM_OPEN    (0x02)  /* IOSCM : Opened  */
#define IOSCM_START   (0x04)  /* IOSCM : Started */
#define IOSCM_INSTALL (0x08)  /* IOSCM : Installed */
#define IOSCM_INVOS   (0x10)  /* IOSCM : GetVersionEx() Error */

/*  Start/Stop IOSCM Manager Function Prototypes */
int IOSCM_Start(void);
int IOSCM_Stop(void);

#endif
