﻿Imports Microsoft.VisualBasic.MsgBoxStyle

Public Class Form1

    '--------------------------------------------------------------------------------------------------
    'VB6用直接I/O制御関数群
    Private Declare Function InpB Lib "VBIOSCM_DLL.DLL" Alias "_InpB@4" (ByVal Port As Integer) As Integer
    Private Declare Function InpW Lib "VBIOSCM_DLL.DLL" Alias "_InpW@4" (ByVal Port As Integer) As Integer
    Private Declare Function InpD Lib "VBIOSCM_DLL.DLL" Alias "_InpD@4" (ByVal Port As Integer) As Long
    Private Declare Sub OutB Lib "VBIOSCM_DLL.DLL" Alias "_OutB@8" (ByVal Port As Integer, ByVal dat As Integer)
    Private Declare Sub OutW Lib "VBIOSCM_DLL.DLL" Alias "_OutW@8" (ByVal Port As Integer, ByVal dat As Integer)
    Private Declare Sub OutD Lib "VBIOSCM_DLL.DLL" Alias "_OutD@8" (ByVal Port As Integer, ByVal dat As Long)
    'VB6用直接I/O制御関数開始／終了処理
    Private Declare Function IOSCM_Start Lib "VBIOSCM_DLL.DLL" Alias "_IOSCM_Start@0" () As Integer
    Private Declare Function IOSCM_Stop Lib "VBIOSCM_DLL.DLL" Alias "_IOSCM_Stop@0" () As Integer
    '--------------------------------------------------------------------------------------------------

    Dim LatestVer As String = "Ver. 2010.05.17"
    Dim filePathIniFile As String

    Private fIOAccess As Boolean

    Private Const DEFAULT_DATA_PORT As Integer = &H378
    Private wPort0 As Integer
    Private wPort1 As Integer
    Private wPort2 As Integer

    Private Const DATA_READ As Integer = 32
    Private Const DATA_WRITE As Integer = 0
    Private Const DATA_STROBE As Integer = 1

    Private Const sFR0 As String = "データレジスタ"
    Private Const sFR1 As String = "ステータスレジスタ"
    Private Const sFR2 As String = "コマンドレジスタ"

    Private pow_2(8) As Integer

    Private Function Binary(ByVal s As Object) As Object

        Dim i As Integer
        Binary = ""

        For i = 7 To 0 Step -1
            If s And pow_2(i) Then
                Binary = Binary & "1"
            Else
                Binary = Binary & "0"
            End If
        Next i

    End Function

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        ' I/O制御開始
        Dim ret As Integer
        ret = IOSCM_Start
        If ret And 1 Then
            fIOAccess = False
            MsgBox("'Button1_Click: 直接I/O制御処理を開始できません。")
            Exit Sub
        End If
        fIOAccess = True
        Button1.BackColor = Color.Yellow
        '以後は直接I/O制御が可能になります

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        ' I/O制御終了
        Dim ret As Integer

        '直接I/O制御終了処理をコール
        ret = IOSCM_Stop
        If ret <> 0 Then
            MsgBox("'Button2_Click: 直接I/O制御停止処理でエラーが発生しました。")
            Exit Sub
        End If
        fIOAccess = False
        Button1.BackColor = Color.White

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        ' データレジスタ・インプット
        Dim ret As Integer

        If fIOAccess = False Then
            MsgBox("'Button3_Click: I/O制御開始処理を行ってください。")
            Exit Sub
        End If
        ret = InpB(wPort0)
        TextBox1.Text = String.Format("{0:X2}", ret)
        TextBox2.Text = ret
        TextBox3.Text = Binary(ret)

    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click

        ' データレジスタ・アウトプット
        If fIOAccess = False Then
            MsgBox("'Button4_Click: I/O制御開始処理を行ってください。")
            Exit Sub
        End If
        If IsDBNull(TextBox5.Text) Or TextBox5.Text = "" Then
            TextBox5.Text = 0
            TextBox6.Text = "00"
            TextBox4.Text = "00000000"
        End If
        If CheckBox1.Checked = True Then
            If MsgBox("'Button4_Click: コントロールポート：0x" & Hex$(wPort0) & "にデータ：0x" & _
                      TextBox6.Text & "を書きこみます", vbOKCancel + vbExclamation, _
                      "確認") = vbCancel Then
                Exit Sub
            End If
        End If
        Call OutB(wPort0, TextBox5.Text)

    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click

        ' ステータスレジスタ・インプット
        Dim ret As Integer

        If fIOAccess = False Then
            MsgBox("'Button5_Click: I/O制御開始処理を行ってください。")
            Exit Sub
        End If
        ret = InpB(wPort1)
        TextBox9.Text = String.Format("{0:X2}", ret)
        TextBox8.Text = ret
        TextBox7.Text = Binary(ret)

    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click

        ' コマンドレジスタ・アウトプット
        If fIOAccess = False Then
            MsgBox("'Button6_Click: I/O制御開始処理を行ってください。")
            Exit Sub
        End If
        If IsDBNull(TextBox11.Text) Or TextBox11.Text = "" Then
            TextBox11.Text = 0
            TextBox12.Text = "00"
            TextBox10.Text = "00000000"
        End If
        If CheckBox1.Checked = True Then
            If MsgBox("'Button6_Click: コントロールポート：0x" & Hex$(wPort2) & "にデータ：0x" & _
                      TextBox12.Text & "を書きこみます", vbOKCancel + vbExclamation, _
                      "確認") = vbCancel Then
                Exit Sub
            End If
        End If
        Call OutB(wPort2, TextBox11.Text)

    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click

        ' コマンドレジスタ・インプット
        Dim ret As Integer

        If fIOAccess = False Then
            MsgBox("'Button7_Click: I/O制御開始処理を行ってください。")
            Exit Sub
        End If
        ret = InpB(wPort2)
        TextBox15.Text = String.Format("{0:X2}", ret)
        TextBox14.Text = ret
        TextBox13.Text = Binary(ret)

    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click

        ClrText()

    End Sub

    Private Sub ClrText()

        TextBox1.Text = ""
        TextBox2.Text = ""
        TextBox3.Text = ""
        TextBox4.Text = ""
        TextBox5.Text = ""
        TextBox6.Text = ""
        TextBox7.Text = ""
        TextBox8.Text = ""
        TextBox9.Text = ""
        TextBox10.Text = ""
        TextBox11.Text = ""
        TextBox12.Text = ""
        TextBox13.Text = ""
        TextBox14.Text = ""
        TextBox15.Text = ""

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing

        ' I/O制御終了
        Dim ret As Integer
        WtIniFile()
        '直接I/O制御終了処理をコール
        If fIOAccess = True Then
            MsgBox("'Form1_FormClosing: I/O制御終了処理を行ってから終了します。")
            ret = IOSCM_Stop
            If ret <> 0 Then
                MsgBox("'Form1_FormClosing: 直接I/O制御停止処理でエラーが発生しました。")
                'Exit Sub
            End If
        End If
        fIOAccess = False
        Button1.BackColor = Color.White

    End Sub

    Private Sub RadioButton1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton1.Click

        wPort0 = &H3BC
        Call SetBaseAddr()
        Call SetFrameCaption()

    End Sub

    Private Sub RadioButton2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton2.Click

        wPort0 = &H378
        Call SetBaseAddr()
        Call SetFrameCaption()

    End Sub

    Private Sub RadioButton3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton3.Click

        wPort0 = &H278
        Call SetBaseAddr()
        Call SetFrameCaption()

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        fIOAccess = False

        pow_2(0) = 1
        pow_2(1) = 2
        pow_2(2) = 4
        pow_2(3) = 8
        pow_2(4) = 16
        pow_2(5) = 32
        pow_2(6) = 64
        pow_2(7) = 128

        wPort0 = DEFAULT_DATA_PORT
        setini()
        RdIniFile()

        RadioButton1.Checked = False
        RadioButton2.Checked = False
        RadioButton3.Checked = False

        Select Case wPort0
            Case &H3BC
                RadioButton1.Checked = True
            Case &H378
                RadioButton2.Checked = True
            Case &H278
                RadioButton3.Checked = True
            Case Else
                MsgBox("'SetBaseAddr: 規定外のアドレスが指定されています。0x3BCに変更します。")
                wPort0 = &H3BC
                RadioButton2.Checked = True
        End Select
        Call SetBaseAddr()
        Call SetFrameCaption()

    End Sub

    Private Sub RdIniFile()

        Dim OldPath_IniFile As String = "LPTCheck_VBNet_201005xx.ini"
        Dim sR As System.IO.StreamReader = Nothing
        Dim str As String
        Dim ssbuf(16) As String
        Dim delim As String = "="

        Try
            ' IniFile のフルパス取得
            filePathIniFile = IO.Path.GetFullPath("LPTCheck_VBNet.ini")
            sR = New IO.StreamReader(filePathIniFile)

            '内容を一行ずつ読み込む
            While sR.Peek() > -1
                str = sR.ReadLine() ' 1行読込
                If Not (Mid(str, 1, 1) = "[") Then
                    ssbuf = str.Split(delim)
                    Select Case ssbuf(0)
                        Case "Version"
                            Label1.Text = ssbuf(1) ' Version
                        Case "Left"
                            Me.Left = Convert.ToInt32(ssbuf(1)) ' Form Position Left
                        Case "Top"
                            Me.Top = Convert.ToInt32(ssbuf(1)) ' Form Position Top
                        Case "Width"
                            Me.Width = Convert.ToInt32(ssbuf(1)) ' Form Position Width
                        Case "Height"
                            Me.Height = Convert.ToInt32(ssbuf(1)) ' Form Position Height
                        Case "wPort0"
                            wPort0 = Convert.ToInt32(ssbuf(1)) ' wPort0
                        Case "checkOFoutput"
                            CheckBox1.Checked = Convert.ToBoolean(ssbuf(1)) ' check of output
                        Case Else
                            ssbuf(1) = ssbuf(1)
                    End Select
                End If
            End While
            '閉じる
            sR.Close()

            '　iniファイルのバージョン判定と旧ファイルのバックアップ
            If Not (Label1.Text = LatestVer) Then
                Select Case Label1.Text
                    Case "Ver. 2010.05.06"
                        OldPath_IniFile = "LPTCheck_VBNet_20100506.ini"
                    Case Else
                        OldPath_IniFile = "LPTCheck_VBNet_201005xx.ini"
                End Select

                MsgBox("'RdIniFile: " + Label1.Text _
                       + " LPTCheck_VBNet.ini ファイルを現バージョンに変換し、" _
                       + vbCrLf + "　　　古いファイルは " _
                       + OldPath_IniFile + " に変更します。")
                ' IniFile のフルパス取得
                Label1.Text = LatestVer
                filePathIniFile = IO.Path.GetFullPath("LPTCheck_VBNet.ini")
                ' 拡張子を変更
                System.IO.File.Delete(OldPath_IniFile)
                System.IO.File.Move("LPTCheck_VBNet.ini", OldPath_IniFile)
            End If

        Catch ex As Exception
            If Err.Number = "53" Then
                MsgBox("'RdIniFile: LPTCheck_VBNet.ini が見つかりません。" + vbCrLf _
                       + "　　　初期値で作成します。")
            Else
                MsgBox("処理: btn1_Click" & vbCrLf & "発生: " & ex.Source & vbCrLf _
                       & vbCrLf & "説明: " & ex.Message _
                       & "'RdIniFile: LPTCheck_VBNet.ini が壊れています。初期値で作成します。" _
                       , Critical, "例外 No." & Err.Number)
                setIni()
            End If

            ' 一旦カレントフォルダにIniFile を書き出す
            filePathIniFile = "LPTCheck_VBNet.ini"
            WtIniFile()
            ' IniFile のフルパス取得
            filePathIniFile = IO.Path.GetFullPath("LPTCheck_VBNet.ini")

        Finally
            If Not (sR Is Nothing) Then
                sR.Close()
            End If

        End Try

    End Sub

    Private Sub SetBaseAddr()

        Select Case wPort0
            Case &H3BC
            Case &H378
            Case &H278
            Case Else
                MsgBox("'SetBaseAddr: 規定外のアドレスが指定されています。0x3BCに変更します。")
                wPort0 = &H3BC
        End Select
        wPort1 = wPort0 + 1
        wPort2 = wPort0 + 2

    End Sub

    Private Sub SetFrameCaption()
        GroupBox3.Text = sFR0 & "(" & Hex$(wPort0) & ")"
        GroupBox4.Text = sFR1 & "(" & Hex$(wPort1) & ")"
        GroupBox5.Text = sFR2 & "(" & Hex$(wPort2) & ")"
    End Sub

    Private Sub setini()

        ClrText()
        Label1.Text = LatestVer ' Version
        Me.Left = 0 ' Form Position Left
        Me.Top = 0 ' Form Position Top
        Me.Width = 665 ' Form Position Width
        Me.Height = 589 ' Form Position Height
        CheckBox1.Checked = True ' check of output

    End Sub

    Private Sub TextBox4_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox4.Validating

        Dim i As Integer
        Dim c As Integer

        c = 0
        For i = 1 To 8
            If Mid(TextBox4.Text, i, 1) = "1" Then
                c = c Or pow_2(7 - i + 1)
            End If
        Next i
        TextBox5.Text = c
        TextBox6.Text = String.Format("{0:X2}", c)

    End Sub

    Private Sub TextBox5_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox5.Validating

        TextBox6.Text = String.Format("{0:X2}", Convert.ToInt32(TextBox5.Text))
        TextBox4.Text = Binary(TextBox5.Text)
        Me.Refresh()

    End Sub

    Private Sub TextBox6_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox6.Validating

        TextBox5.Text = Val("&H" & TextBox6.Text)
        TextBox4.Text = Binary(TextBox5.Text)
        TextBox6.Text = String.Format("{0:X2}", Convert.ToInt32(TextBox5.Text))
        Me.Refresh()

    End Sub

    Private Sub TextBox10_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox10.Validating

        Dim i As Integer
        Dim c As Integer

        c = 0
        For i = 1 To 8
            If Mid(TextBox10.Text, i, 1) = "1" Then
                c = c Or pow_2(7 - i + 1)
            End If
        Next i
        TextBox11.Text = c
        TextBox12.Text = String.Format("{0:X2}", c)

    End Sub

    Private Sub TextBox11_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox11.Validating

        TextBox12.Text = String.Format("{0:X2}", Convert.ToInt32(TextBox11.Text))
        TextBox10.Text = Binary(TextBox11.Text)
        Me.Refresh()

    End Sub

    Private Sub TextBox12_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TextBox12.Validating

        TextBox11.Text = Val("&H" & TextBox12.Text)
        TextBox10.Text = Binary(TextBox11.Text)
        TextBox12.Text = String.Format("{0:X2}", Convert.ToInt32(TextBox11.Text))
        Me.Refresh()

    End Sub

    Private Sub WtIniFile()

        Dim Writer As New IO.StreamWriter(filePathIniFile)

        Try
            Writer.WriteLine("[Version]") ' Comment
            Writer.WriteLine("Version=" + Label1.Text) ' Version

            Writer.WriteLine("[Window Positions]") ' Comment
            Writer.WriteLine("Left=" + Me.Left.ToString) ' Form Position Left
            Writer.WriteLine("Top=" + Me.Top.ToString) ' Form Position Top
            Writer.WriteLine("Width=" + Me.Width.ToString) ' Form Position Width
            Writer.WriteLine("Height=" + Me.Height.ToString) ' Form Position Height

            Writer.WriteLine("[Port]") ' Comment
            Writer.WriteLine("wPort0=" + wPort0.ToString) ' wPort0

            Writer.WriteLine("[Ckecks]") ' Comment
            Writer.WriteLine("checkOFoutput=" + CheckBox1.Checked.ToString) ' check of output

            Writer.Close()

        Catch ex As Exception

            MsgBox("処理: btn1_Click" & vbCrLf & "発生: " & ex.Source & vbCrLf & _
                    vbCrLf & "説明: " & ex.Message, Critical, "例外 No." & Err.Number)
            Writer.Close()
            MsgBox("'WtIniFile: LPTCheck_VBNet.ini が書き込めません。")

        End Try

    End Sub

End Class
