﻿Imports Microsoft.VisualBasic.MsgBoxStyle
Imports System.Runtime.InteropServices
Imports System.Environment

Public Class Form1

    Dim LatestVer As String = "Ver.2015.05.20"

    Dim folderPathAppdata As String
    Dim folderPathInidata As String
    Dim filePathInidata As String
    Dim folderPathCurrent As String
    Dim filePathCurrent As String

    Dim IniFolderName As String = "JA2GRC\Hamlog_Test"
    Dim IniFileName As String = "Hamlog_Test"
    Dim IniFileExt As String = ".ini"
    Dim IniFile As String = IniFileName + IniFileExt
    Dim OldCfgFileName As String = "Hamlog_Test"
    Dim OldCfgFileExt As String = ".ini"
    Dim OldCfgFile As String = OldCfgFileName + OldCfgFileExt

    Private Const WM_COPYDATA As Int32 = &H4A

    Public Const THW_ENTER As Int32 = &H10000  ' データ送信後、ENTERキーを押したのと同じ
    Public Const THW_ENTERn As Int32 = &HFEFFFF  ' ENTER 抜き出しデータ
    Public Const THW_FOCUS As Int32 = &H20000  ' データ送信後、編集ボックスにフォーカス
    Public Const THW_FOCUSn As Int32 = &HFDFFFF  ' ENTER 抜き出しデータ
    Public Const THW_SAVEBOX_ON As Int32 = &H40000 ' データ保存時、確認MessageBox表示あり
    Public Const THW_SAVEBOX_OFF As Int32 = &H80000 ' データ保存時、確認MessageBox表示なし
    Public Const THW_SAVEBOXn As Int32 = &HF3FFFF  ' ENTER 抜き出しデータ
    Public Const THW_APPLIHWND As Int32 = &H100000 ' メインウインドウのハンドルを返す
    Public Const THW_APPLIHWNDn As Int32 = &HEFFFFF  ' ENTER 抜き出しデータ
    Public Const THW_OFF As Int32 = 0 ' 何もしない
    Public Const THW_COMMANDn As Int32 = &HFF0000  ' ENTER 抜き出しデータ

    Public Const THW_CALL As Int32 = 0  ' コールサイン
    Public Const THW_PORTABLE As Int32 = 1  ' 移動エリア
    Public Const THW_DATE As Int32 = 2  ' 日付
    Public Const THW_TIME As Int32 = 3  ' 時間
    Public Const THW_HIS As Int32 = 4  ' His RST
    Public Const THW_MY As Int32 = 5  ' My RST
    Public Const THW_FREQ As Int32 = 6  ' 周波数
    Public Const THW_MODE As Int32 = 7  ' 電波形式
    Public Const THW_CODE As Int32 = 8  ' コード
    Public Const THW_GL As Int32 = 9 ' GL
    Public Const THW_QSL As Int32 = 10 ' QSL
    Public Const THW_NAME As Int32 = 11 ' 氏名
    Public Const THW_QTH As Int32 = 12 ' QTH
    Public Const THW_REMARKS1 As Int32 = 13 ' Remarks1
    Public Const THW_REMARKS2 As Int32 = 14 ' Remarks2
    Public Const THW_ALL As Int32 = 15 ' 全入力欄
    Public Const THW_CLEAR As Int32 = 16 ' 入力バッファクリア
    Public Const THW_DUP As Int32 = 17 ' デュープチェック
    Public Const THW_SAVE As Int32 = 18 ' データの登録

    Public Const THW_Get_CALL As Int32 = 100  ' コールサイン
    Public Const THW_Get_PORTABLE As Int32 = 101  ' 移動エリア
    Public Const THW_Get_DATE As Int32 = 102  ' 日付
    Public Const THW_Get_TIME As Int32 = 103  ' 時間
    Public Const THW_Get_HIS As Int32 = 104  ' His RST
    Public Const THW_Get_MY As Int32 = 105  ' My RST
    Public Const THW_Get_FREQ As Int32 = 106  ' 周波数
    Public Const THW_Get_MODE As Int32 = 107  ' 電波形式
    Public Const THW_Get_CODE As Int32 = 108  ' コード
    Public Const THW_Get_GL As Int32 = 109 ' GL
    Public Const THW_Get_QSL As Int32 = 110 ' QSL
    Public Const THW_Get_NAME As Int32 = 111 ' 氏名
    Public Const THW_Get_QTH As Int32 = 112 ' QTH
    Public Const THW_Get_REMARKS1 As Int32 = 113 ' Remarks1
    Public Const THW_Get_REMARKS2 As Int32 = 114 ' Remarks2
    Public Const THW_Get_ALL As Int32 = 115 ' 全入力欄
    Public Const THW_Get_DX As Int32 = 116 ' DXフラグ

    Public Structure COPYDATASTRUCT

        Public dwData As Int32
        Public cbData As Int32
        Public lpData As String

    End Structure

    Declare Function FindWindow32 Lib "user32.dll" Alias "FindWindowA" _
            (ByVal cName As String, ByVal wName As String) As Int32

    Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" _
            (ByVal wnd As Int32, ByVal wMsg As Int32, ByVal wParam As Int32, _
            ByRef lParam As COPYDATASTRUCT) As Int32

    Declare Function SetForegroundWindow Lib "user32.dll" (ByVal wnd As Int32) As Int32

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        ' Hamlogへ送信
        sendHamlog()

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        ' テストデータをセット
        setTestData()

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        ' 入力欄クリア
        clearINbox()

    End Sub

    Private Sub clearINbox()

        ' 入力欄クリア
        TextBox1.Text = "" 'His Call
        TextBox2.Text = "" 'Date
        TextBox3.Text = "" 'Time UTC
        TextBox4.Text = "" 'His RST
        TextBox5.Text = "" 'My RST
        TextBox6.Text = "" 'Freq
        TextBox7.Text = "" 'Mode
        TextBox8.Text = "" 'Code
        TextBox9.Text = "" 'GL
        TextBox10.Text = "" 'QSL
        TextBox11.Text = "" 'Name
        TextBox12.Text = "" 'QTH
        TextBox13.Text = "" 'Remarks1
        TextBox14.Text = "" 'Remarks2

        CheckBox1.Checked = False ' check of DX
        CheckBox2.Checked = False ' check of CQ
        CheckBox3.Checked = False ' check of C1
        CheckBox4.Checked = False ' check of C2

        ComboBox1.Text = "ENTER_OFF"
        ComboBox2.Text = "FOCUS_OFF"
        ComboBox3.Text = "NON_FLAG"
        ComboBox4.Text = "APPLIHWND_OFF"
        ComboBox5.Text = "Send His Call"

        setENTER()
        setFOCUS()
        setSAVEBOX()
        setAPPLIHWND()
        setCOMMAND()

    End Sub

    Private Sub ComboBox1_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox1.SelectionChangeCommitted

        ' THW_ENTER の設定
        setENTER()

    End Sub

    Private Sub ComboBox2_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox2.SelectionChangeCommitted

        ' THW_FOCUS の設定
        setFOCUS()

    End Sub

    Private Sub ComboBox3_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox3.SelectionChangeCommitted

        ' THW_SAVEBOX の設定
        setSAVEBOX()

    End Sub

    Private Sub ComboBox4_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox4.SelectionChangeCommitted

        ' THW_APPLIHWND の設定
        setAPPLIHWND()

    End Sub

    Private Sub ComboBox5_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox5.SelectionChangeCommitted

        ' THW_CALL の設定
        setCOMMAND()

    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing

        ' プログラム終了処理
        WtIniFile()

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' プログラム初期化
        getFilePath()
        setIni()
        RdIniFile()

        setENTER()
        setFOCUS()
        setSAVEBOX()
        setAPPLIHWND()
        setCOMMAND()

    End Sub

    Private Sub getFilePath()

        '現在の非ローミングユーザーのApplication Dataフォルダを取得
        '(C:\Documents and Settings\UserName\Local Settings\Application Data)
        folderPathAppdata = GetFolderPath(SpecialFolder.LocalApplicationData)
        folderPathInidata = folderPathAppdata + "\" + IniFolderName
        IniFile = IniFileName + IniFileExt
        filePathInidata = folderPathInidata + "\" + IniFile

        folderPathCurrent = System.IO.Directory.GetCurrentDirectory()
        OldCfgFile = OldCfgFileName + OldCfgFileExt
        filePathCurrent = folderPathCurrent + "\" + OldCfgFile

        ' カレントフォルダを表示
        'MessageBox.Show("カレントファイルパスは" + filePathCurrent)

        ' 設定ファイル保存用フォルダが存在しているかどうか確認する
        If System.IO.Directory.Exists(folderPathInidata) Then
            'MessageBox.Show(folderPathInidata + "ディレクトリは存在します")
        Else
            MessageBox.Show("設定ファイル保存用フォルダ " + folderPathInidata + " が存在しませんので作成します")
            System.IO.Directory.CreateDirectory(folderPathInidata)
        End If

        ' 設定ファイル保存用フォルダに設定ファイルが無く
        ' カレントフォルダに設定ファイルが有れば
        ' 設定ファイル保存用フォルダに移動（コピー）する

        ' 設定ファイル保存用フォルダに設定ファイルが存在しているかどうか確認する
        If System.IO.File.Exists(filePathInidata) Then
            'MessageBox.Show("設定ファイル保存用フォルダに設定ファイルファイルは存在します" + filePathInidata)
        Else
            'MessageBox.Show("設定ファイル保存用フォルダ" + folderPathInidata + "に設定ファイルファイルは存在しません")
            ' カレントフォルダに設定ファイルが存在しているかどうか確認する
            If System.IO.File.Exists(filePathCurrent) Then
                'MessageBox.Show("カレントフォルダに設定ファイルは存在します" + filePathCurrent)
                MessageBox.Show("以前の形式の設定ファイル" + filePathCurrent + "をコピーします")
                System.IO.File.Copy(filePathCurrent, filePathInidata)
            Else
                'MessageBox.Show("カレントフォルダに設定ファイルは存在しません" + folderPathCurrent)
            End If
        End If

    End Sub

    Private Shared Function LenB(ByVal str As String) As Integer

        'VB6のLenBの代わりになりそうな関数
        'Shift JISに変換したときに必要なバイト数を返す
        Return System.Text.Encoding.GetEncoding(932).GetByteCount(str)

    End Function

    Private Sub RdIniFile()

        Dim OldFilePathIniFile As String
        Dim OldFileNameIniFile As String = IniFileName + "_201xxxxx" + IniFileExt
        Dim sR As System.IO.StreamReader = Nothing
        Dim str As String
        Dim ssbuf(16) As String
        'Dim delim As String = "="
        Dim delim As Char = "="c

        Try
            sR = New IO.StreamReader(filePathInidata)

            '内容を一行ずつ読み込む
            While sR.Peek() > -1
                str = sR.ReadLine() ' 1行読込
                If Not (Mid(str, 1, 1) = "[") Then
                    ssbuf = str.Split(delim)
                    Select Case ssbuf(0)
                        Case "Version"
                            Label1.Text = ssbuf(1) ' Version
                        Case "Left"
                            Me.Left = Convert.ToInt32(ssbuf(1)) ' Form Position Left
                        Case "Top"
                            Me.Top = Convert.ToInt32(ssbuf(1)) ' Form Position Top
                        Case "Width"
                            Me.Width = Convert.ToInt32(ssbuf(1)) ' Form Position Width
                        Case "Height"
                            Me.Height = Convert.ToInt32(ssbuf(1)) ' Form Position Height

                        Case "textOFHisCall"
                            TextBox1.Text = ssbuf(1) ' text of His Call
                        Case "textOFDate"
                            TextBox2.Text = ssbuf(1) ' text of Date
                        Case "textOFTime"
                            TextBox3.Text = ssbuf(1) ' text of Time
                        Case "textOFHisRST"
                            TextBox4.Text = ssbuf(1) ' text of His RST
                        Case "textOFMyRST"
                            TextBox5.Text = ssbuf(1) ' text of My RST
                        Case "textOFFreq"
                            TextBox6.Text = ssbuf(1) ' text of Freq
                        Case "textOFMode"
                            TextBox7.Text = ssbuf(1) ' text of Mode
                        Case "textOFCode"
                            TextBox8.Text = ssbuf(1) ' text of Code
                        Case "textOFGL"
                            TextBox9.Text = ssbuf(1) ' text of GL
                        Case "textOFQSL"
                            TextBox10.Text = ssbuf(1) ' text of QSL
                        Case "textOFHisName"
                            TextBox11.Text = ssbuf(1) ' text of His Name
                        Case "textOFQTH"
                            TextBox12.Text = ssbuf(1) ' text of QTH
                        Case "textOFRemarks1"
                            TextBox13.Text = ssbuf(1) ' text of Remarks1
                        Case "textOFRemarks2"
                            TextBox14.Text = ssbuf(1) ' text of Remarks2

                        Case "checkOFDX"
                            CheckBox1.Checked = Convert.ToBoolean(ssbuf(1)) ' check of DX
                        Case "checkOFCQ"
                            CheckBox2.Checked = Convert.ToBoolean(ssbuf(1)) ' check of CQ
                        Case "checkOFC1"
                            CheckBox3.Checked = Convert.ToBoolean(ssbuf(1)) ' check of C1
                        Case "checkOFC2"
                            CheckBox4.Checked = Convert.ToBoolean(ssbuf(1)) ' check of C2

                        Case "textOFENTER"
                            ComboBox1.Text = ssbuf(1) ' text of ENTER
                        Case "textOFFOCUS"
                            ComboBox2.Text = ssbuf(1) ' text of FOCUS
                        Case "textOFSAVEBOX"
                            ComboBox3.Text = ssbuf(1) ' text of SAVEBOX
                        Case "textOFAPPLIHWND"
                            ComboBox4.Text = ssbuf(1) ' text of APPLIHWND
                        Case "textOFCOMMAND"
                            ComboBox5.Text = ssbuf(1) ' text of COMMAND

                        Case Else
                            ssbuf(1) = ssbuf(1)
                    End Select
                End If
            End While
            '閉じる
            sR.Close()

            '　iniファイルのバージョン判定と旧ファイルのバックアップ
            If Not (Label1.Text = LatestVer) Then
                Select Case Label1.Text
                    Case "Ver.2012.10.23"
                        OldFileNameIniFile = IniFileName + "_20121023" + IniFileExt
                    Case "Ver.2011.01.23"
                        OldFileNameIniFile = IniFileName + "_20110123" + IniFileExt
                    Case "Ver.2011.01.17"
                        OldFileNameIniFile = IniFileName + "_20110117" + IniFileExt
                    Case Else
                        OldFileNameIniFile = IniFileName + "_201xxxxx" + IniFileExt
                End Select

                MsgBox("'08: " + Label1.Text _
                       + " Hamlog_Test.ini ファイルを現バージョンに変換し、" _
                       + vbCrLf + "　　　古いファイルは " _
                       + OldFileNameIniFile + " に変更します。")

                ' バージョンの付け替え
                Label1.Text = LatestVer
                ' ファイルパスの設定
                OldFilePathIniFile = folderPathInidata + "\" + OldFileNameIniFile
                ' ファイル名を変更
                System.IO.File.Move(filePathInidata, OldFilePathIniFile)
                ' 新しい設定ファイルを書き出しておく
                WtIniFile()
            End If

        Catch ex As Exception
            If Err.Number = "53" Then
                MsgBox("'09: " + IniFile + "が見つかりません。" + vbCrLf _
                       + "　　　初期値で作成します。")
            Else
                MsgBox("処理: btn1_Click" & vbCrLf & "発生: " & ex.Source & vbCrLf _
                       & vbCrLf & "説明: " & ex.Message _
                       & "    " & IniFile & " が壊れています。初期値で作成します。" _
                       , Critical, "例外 No." & Err.Number)
                setIni()
            End If

            ' 一旦IniFile を書き出す
            WtIniFile()

        Finally
            If Not (sR Is Nothing) Then
                sR.Close()
            End If

        End Try

    End Sub

    Private Sub sendHamlog()

        ' HamLogへデータ送出
        Dim Hwnd1, Hwnd2 As Int32
        Dim cds As COPYDATASTRUCT

        Hwnd1 = FindWindow32("TThwin", vbNullString)
        If Hwnd1 < 1 Then   ' ハムログが起動していない
            MsgBox("'03: HamLog が見つかりません。" + vbCrLf + "　　　起動してください。")
            Exit Sub
        End If

        Dim dwData As Int32
        Dim delimSp As String = " "
        Dim delimLf As String = vbCrLf
        Dim Cbuf(32) As String

        Cbuf = TextBox15.Text.Split(delimSp)
        dwData = Convert.ToInt32(Cbuf(0))
        cds.dwData = dwData ' コマンド
        cds.cbData = Convert.ToInt32(TextBox16.Text) ' データの長さ
        cds.lpData = TextBox17.Text ' データ
        Hwnd2 = SendMessage(Hwnd1, WM_COPYDATA, Me.Handle, cds)

        If Hwnd2 > 0 Then
            'SetForegroundWindow(Hwnd2) ' 入力ウインドウにフォーカス
        End If

    End Sub

    Private Sub setAPPLIHWND()

        ' THW_APPLIHWND の設定
        Dim dwData As Int32
        Dim delim As String = " "
        Dim Cbuf(32) As String

        Cbuf = TextBox15.Text.Split(delim)
        dwData = Convert.ToInt32(Cbuf(0)) And THW_APPLIHWNDn

        Select Case ComboBox4.SelectedItem
            Case "APPLIHWND_OFF"
                dwData = dwData Or THW_OFF
            Case "APPLIHWND_ON"
                dwData = dwData Or THW_APPLIHWND
            Case Else

        End Select

        TextBox15.Text = Convert.ToString(dwData) + "   0x" + dwData.ToString("X5")

    End Sub

    Private Sub setCOMMAND()

        ' THW_CALL の設定
        Dim dwData As Int32
        Dim delimSp As String = " "
        Dim delimCrLf As String = vbCrLf
        Dim Cbuf(32) As String

        Dim DC12 As Int32 = 0
        Dim DXON As Int32 = Convert.ToInt32("0008", 16)
        Dim CQON As Int32 = Convert.ToInt32("0010", 16)
        Dim C1ON As Int32 = Convert.ToInt32("0020", 16)
        Dim C2ON As Int32 = Convert.ToInt32("0040", 16)
        Dim DXOFF As Int32 = Convert.ToInt32("FFF7", 16)
        Dim CQOFF As Int32 = Convert.ToInt32("FFEF", 16)
        Dim C1OFF As Int32 = Convert.ToInt32("FFDF", 16)
        Dim C2OFF As Int32 = Convert.ToInt32("FFBF", 16)

        Cbuf = TextBox15.Text.Split(delimSp)
        dwData = Convert.ToInt32(Cbuf(0)) And THW_COMMANDn

        Select Case ComboBox5.SelectedItem
            Case "Send His Call"
                dwData = dwData Or THW_CALL
                TextBox17.Text = TextBox1.Text
            Case "Send Portable"
                dwData = dwData Or THW_PORTABLE
                TextBox17.Text = TextBox1.Text
            Case "Send Date"
                dwData = dwData Or THW_DATE
                TextBox17.Text = TextBox2.Text
            Case "Send Time"
                dwData = dwData Or THW_TIME
                TextBox17.Text = TextBox3.Text
            Case "Send His"
                dwData = dwData Or THW_HIS
                TextBox17.Text = TextBox4.Text
            Case "Send My"
                dwData = dwData Or THW_MY
                TextBox17.Text = TextBox5.Text
            Case "Send Freq"
                dwData = dwData Or THW_FREQ
                TextBox17.Text = TextBox6.Text
            Case "Send Mode"
                dwData = dwData Or THW_MODE
                TextBox17.Text = TextBox7.Text
            Case "Send Code"
                dwData = dwData Or THW_CODE
                TextBox17.Text = TextBox7.Text
            Case "Send GL"
                dwData = dwData Or THW_GL
                TextBox17.Text = TextBox8.Text
            Case "Send QSL"
                dwData = dwData Or THW_QSL
                TextBox17.Text = TextBox10.Text
            Case "Send His Name"
                dwData = dwData Or THW_NAME
                TextBox17.Text = TextBox11.Text
            Case "Send QTH"
                dwData = dwData Or THW_QTH
                TextBox17.Text = TextBox12.Text
            Case "Send Remarks1"
                dwData = dwData Or THW_REMARKS1
                TextBox17.Text = TextBox13.Text
            Case "Send Remarks2"
                dwData = dwData Or THW_REMARKS2
                TextBox17.Text = TextBox14.Text
            Case "Send ALL"
                dwData = dwData Or THW_ALL
                TextBox17.Text = delimCrLf ' 0:移動エリア?
                TextBox17.Text = TextBox17.Text + TextBox1.Text + delimCrLf ' 1:コールサイン
                TextBox17.Text = TextBox17.Text + TextBox2.Text + delimCrLf ' 2:日付 JST
                TextBox17.Text = TextBox17.Text + TextBox3.Text + delimCrLf ' 3:時間 JST
                TextBox17.Text = TextBox17.Text + TextBox4.Text + delimCrLf ' 4:His RST
                TextBox17.Text = TextBox17.Text + TextBox5.Text + delimCrLf ' 5:My RST
                TextBox17.Text = TextBox17.Text + TextBox6.Text + delimCrLf ' 6:周波数
                TextBox17.Text = TextBox17.Text + TextBox7.Text + delimCrLf ' 7:電波形式Mode
                TextBox17.Text = TextBox17.Text + TextBox8.Text + delimCrLf ' 9:Code
                TextBox17.Text = TextBox17.Text + TextBox9.Text + delimCrLf ' 9:GL
                TextBox17.Text = TextBox17.Text + TextBox10.Text + delimCrLf ' 10:QSL
                TextBox17.Text = TextBox17.Text + TextBox11.Text + delimCrLf ' 11:His Name
                TextBox17.Text = TextBox17.Text + TextBox12.Text + delimCrLf ' 12:QTH
                TextBox17.Text = TextBox17.Text + TextBox13.Text + delimCrLf ' 13:Remarks1
                TextBox17.Text = TextBox17.Text + TextBox14.Text + delimCrLf ' 14:Remarks2
                If CheckBox1.Checked = True Then  ' DX checkbox
                    DC12 = DC12 Or DXON
                Else
                    DC12 = DC12 And DXOFF
                End If
                If CheckBox2.Checked = True Then  ' CQ checkbox
                    DC12 = DC12 Or CQON
                Else
                    DC12 = DC12 And CQOFF
                End If
                If CheckBox3.Checked = True Then  ' 1 checkbox
                    DC12 = DC12 Or C1ON
                Else
                    DC12 = DC12 And C1OFF
                End If
                If CheckBox4.Checked = True Then  ' 2 checkbox
                    DC12 = DC12 Or C2ON
                Else
                    DC12 = DC12 And C2OFF
                End If
                TextBox17.Text = TextBox17.Text + DC12.ToString + delimCrLf ' 15:DC12
            Case "Send CLEAR"
                dwData = dwData Or THW_CLEAR
                TextBox17.Text = vbNull
            Case "Send DUP"
                dwData = dwData Or THW_DUP
                TextBox17.Text = vbNull
            Case "Send SAVE"
                dwData = dwData Or THW_SAVE
                TextBox17.Text = vbNull

            Case "Get His Call"
                dwData = dwData Or THW_Get_CALL
                TextBox17.Text = vbNull
            Case "Get Portable"
                dwData = dwData Or THW_Get_PORTABLE
                TextBox17.Text = vbNull
            Case "Get Date"
                dwData = dwData Or THW_Get_DATE
                TextBox17.Text = vbNull
            Case "Get Time"
                dwData = dwData Or THW_Get_TIME
                TextBox17.Text = vbNull
            Case "Get His"
                dwData = dwData Or THW_Get_HIS
                TextBox17.Text = vbNull
            Case "Get My"
                dwData = dwData Or THW_Get_MY
                TextBox17.Text = vbNull
            Case "Get Freq"
                dwData = dwData Or THW_Get_FREQ
                TextBox17.Text = vbNull
            Case "Get Mode"
                dwData = dwData Or THW_Get_MODE
                TextBox17.Text = vbNull
            Case "Get Code"
                dwData = dwData Or THW_Get_CODE
                TextBox17.Text = vbNull
            Case "Get GL"
                dwData = dwData Or THW_Get_GL
                TextBox17.Text = vbNull
            Case "Get QSL"
                dwData = dwData Or THW_Get_QSL
                TextBox17.Text = vbNull
            Case "Get His Name"
                dwData = dwData Or THW_Get_NAME
                TextBox17.Text = vbNull
            Case "Get QTH"
                dwData = dwData Or THW_Get_QTH
                TextBox17.Text = vbNull
            Case "Get Remarks1"
                dwData = dwData Or THW_Get_REMARKS1
                TextBox17.Text = vbNull
            Case "Get Remarks2"
                dwData = dwData Or THW_Get_REMARKS2
                TextBox17.Text = vbNull
            Case "Get ALL"
                dwData = dwData Or THW_Get_ALL
                TextBox17.Text = vbNull
            Case Else

        End Select

        TextBox15.Text = Convert.ToString(dwData) + "   0x" + dwData.ToString("X5")
        TextBox16.Text = Len(Trim$(TextBox17.Text)).ToString ' 文字列の長さ

    End Sub

    Private Sub setENTER()

        ' THW_ENTER の設定
        Dim dwData As Int32
        Dim delim As String = " "
        Dim Cbuf(32) As String

        Cbuf = TextBox15.Text.Split(delim)
        dwData = Convert.ToInt32(Cbuf(0)) And THW_ENTERn

        Select Case ComboBox1.SelectedItem
            Case "ENTER_OFF"
                dwData = dwData Or THW_OFF
            Case "ENTER_ON"
                dwData = dwData Or THW_ENTER
            Case Else

        End Select

        TextBox15.Text = Convert.ToString(dwData) + "   0x" + dwData.ToString("X5")

    End Sub

    Private Sub setFOCUS()

        ' THW_FOCUS の設定
        Dim dwData As Int32
        Dim delim As String = " "
        Dim Cbuf(32) As String

        Cbuf = TextBox15.Text.Split(delim)
        dwData = Convert.ToInt32(Cbuf(0)) And THW_FOCUSn

        Select Case ComboBox2.SelectedItem
            Case "FOCUS_OFF"
                dwData = dwData Or THW_OFF
            Case "FOCUS_ON"
                dwData = dwData Or THW_FOCUS
            Case Else

        End Select

        TextBox15.Text = Convert.ToString(dwData) + "   0x" + dwData.ToString("X5")

    End Sub

    Private Sub setIni()

        'デフォルト設定
        Label1.Text = LatestVer

        Me.Left = 0 ' Form Position Left
        Me.Top = 0 ' Form Position Top
        Me.Width = 640 ' Form Position Width
        Me.Height = 530 ' Form Position Height

        clearINbox()

    End Sub

    Private Sub setSAVEBOX()

        ' THW_SAVEBOX の設定
        Dim dwData As Int32
        Dim delim As String = " "
        Dim Cbuf(32) As String

        Cbuf = TextBox15.Text.Split(delim)
        dwData = Convert.ToInt32(Cbuf(0)) And THW_SAVEBOXn

        Select Case ComboBox3.SelectedItem
            Case "NON_FLAG"
                dwData = dwData Or THW_OFF
            Case "SAVEBOX_OFF"
                dwData = dwData Or THW_SAVEBOX_OFF
            Case "SAVEBOX_ON"
                dwData = dwData Or THW_SAVEBOX_ON
            Case Else

        End Select

        TextBox15.Text = Convert.ToString(dwData) + "   0x" + dwData.ToString("X5")

    End Sub

    Private Sub setTestData()

        ' テストデータ設定
        TextBox1.Text = "JA2QRZ" 'His Call
        TextBox2.Text = "10/12/31" 'Date
        TextBox3.Text = "23:59J" 'Time JST
        TextBox4.Text = "-15" 'His RST
        TextBox5.Text = "-10" 'My RST
        TextBox6.Text = "14.076" 'Freq
        TextBox7.Text = "JT65A" 'Mode
        TextBox8.Text = "2512" 'Code
        TextBox9.Text = "PM74uu" 'GL
        TextBox10.Text = "J" 'QSL
        TextBox11.Text = "Hamlog_Test" 'Name
        TextBox12.Text = "Hirakata Osaka, JAPAN" 'QTH
        TextBox13.Text = "Remarks1" 'Remarks1
        TextBox14.Text = "Remarks2" 'Remarks2

        CheckBox1.Checked = True ' check of DX
        CheckBox2.Checked = True ' check of CQ
        CheckBox3.Checked = True ' check of C1
        CheckBox4.Checked = True ' check of C2

        setENTER()
        setFOCUS()
        setSAVEBOX()
        setAPPLIHWND()
        setCOMMAND()

    End Sub

    Private Sub WtIniFile()

        Dim Writer As New IO.StreamWriter(filePathInidata)

        Try
            Writer.WriteLine("[Version]") ' Comment
            Writer.WriteLine("Version=" + Label1.Text) ' Version

            Writer.WriteLine("[Window Positions]") ' Comment
            Writer.WriteLine("Left=" + Me.Left.ToString) ' Form Position Left
            Writer.WriteLine("Top=" + Me.Top.ToString) ' Form Position Top
            Writer.WriteLine("Width=" + Me.Width.ToString) ' Form Position Width
            Writer.WriteLine("Height=" + Me.Height.ToString) ' Form Position Height

            Writer.WriteLine("[SendData]") ' Comment
            Writer.WriteLine("textOFHisCall=" + TextBox1.Text) ' text of His Call
            Writer.WriteLine("textOFDate=" + TextBox2.Text) ' text of Date
            Writer.WriteLine("textOFTime=" + TextBox3.Text) ' text of Time
            Writer.WriteLine("textOFHisRST=" + TextBox4.Text) ' text of His RST
            Writer.WriteLine("textOFMyRST=" + TextBox5.Text) ' text of My RST
            Writer.WriteLine("textOFFreq=" + TextBox6.Text) ' text of Freq
            Writer.WriteLine("textOFMode=" + TextBox7.Text) ' text of Mode
            Writer.WriteLine("textOFCode=" + TextBox8.Text) ' text of Code
            Writer.WriteLine("textOFGL=" + TextBox9.Text) ' text of GL
            Writer.WriteLine("textOFQSL=" + TextBox10.Text) ' text of QSL
            Writer.WriteLine("textOFHisName=" + TextBox11.Text) ' text of His Name
            Writer.WriteLine("textOFQTH=" + TextBox12.Text) ' text of QTH
            Writer.WriteLine("textOFRemarks1=" + TextBox13.Text) ' text of Remarks1
            Writer.WriteLine("textOFRemarks2=" + TextBox14.Text) ' text of Remarks2

            Writer.WriteLine("[Ckecks]") ' Comment
            Writer.WriteLine("checkOFDX=" + CheckBox1.Checked.ToString) ' check of DX
            Writer.WriteLine("checkOFCQ=" + CheckBox2.Checked.ToString) ' check of CQ
            Writer.WriteLine("checkOFC1=" + CheckBox3.Checked.ToString) ' check of C1
            Writer.WriteLine("checkOFC2=" + CheckBox4.Checked.ToString) ' check of C2

            Writer.WriteLine("[CommandSetting]") ' Comment
            Writer.WriteLine("textOFENTER=" + ComboBox1.Text) ' text of ENTER
            Writer.WriteLine("textOFFOCUS=" + ComboBox2.Text) ' text of FOCUS
            Writer.WriteLine("textOFSAVEBOX=" + ComboBox3.Text) ' text of SAVEBOX
            Writer.WriteLine("textOFAPPLIHWND=" + ComboBox4.Text) ' text of APPLIHWND
            Writer.WriteLine("textOFCOMMAND=" + ComboBox5.Text) ' text of COMMAND

            Writer.Close()

        Catch ex As Exception

            MsgBox("処理: btn1_Click" & vbCrLf & "発生: " & ex.Source & vbCrLf & _
                    vbCrLf & "説明: " & ex.Message, Critical, "例外 No." & Err.Number)
            Writer.Close()
            MsgBox("'10: " + IniFile + " が書き込めません。")

        End Try

    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)

        If m.Msg = WM_COPYDATA Then
            Dim cds As COPYDATASTRUCT
            cds = CType(Marshal.PtrToStructure(m.LParam, GetType(COPYDATASTRUCT)),  _
                        COPYDATASTRUCT)
            '読込データの分析
            TextBox17.Text = cds.lpData


            'Dim delimLf As String = vbLf
            'Dim Cbuf(32) As String
            'Cbuf = TextBox17.Text.Split(delimLf)
            'TextBox17.Text = TextBox17.Text + "   0x" + Cbuf(0).ToString("X2")

        Else
            MyBase.WndProc(m)
        End If

    End Sub

End Class